/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.function.Function;
import mekanism.common.config.IMekanismConfig;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class EMModConfig
extends ModConfig {
    private static final EMConfigFileTypeHandler MEK_TOML = new EMConfigFileTypeHandler();
    private final IMekanismConfig mekanismConfig;

    public EMModConfig(ModContainer container, IMekanismConfig config) {
        super(config.getConfigType(), (IConfigSpec)config.getConfigSpec(), container, "EvolvedMekanism/" + config.getFileName() + ".toml");
        this.mekanismConfig = config;
    }

    public ConfigFileTypeHandler getHandler() {
        return MEK_TOML;
    }

    public void clearCache(ModConfigEvent event) {
        this.mekanismConfig.clearCache(event instanceof ModConfigEvent.Unloading);
    }

    private static class EMConfigFileTypeHandler
    extends ConfigFileTypeHandler {
        private EMConfigFileTypeHandler() {
        }

        private static Path getPath(Path configBasePath) {
            if (configBasePath.endsWith("serverconfig")) {
                return FMLPaths.CONFIGDIR.get();
            }
            return configBasePath;
        }

        public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
            return super.reader(EMConfigFileTypeHandler.getPath(configBasePath));
        }

        public void unload(Path configBasePath, ModConfig config) {
            super.unload(EMConfigFileTypeHandler.getPath(configBasePath), config);
        }
    }
}

